﻿using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Framework.Web.UI
{
    /// <summary>
    /// ローカライズ機能を持ったリテラル
    /// </summary>
    [DefaultProperty("Text")]
    [ToolboxData("<{0}:LLiteral runat=server></{0}:LLiteral>")]
    public class LLiteral : Literal, ILocalizeControl
    {

        [Category("Custom")]
        [DefaultValue("")]
        public string LTextKey { get; set; }

        #region ILocalizeControl メンバ

        public void Localize(System.Globalization.CultureInfo lang)
        {
            if (this.LTextKey.IsNotEmpty())
            {
                base.Text = LTextMgr.GetText(lang, this.LTextKey);
            }
        }

        #endregion
    }
}
